"use client";

import { useState } from "react";
import Image from "next/image";
import Button from "@/components/ui/button/Button";
import ChangePasswordModal from "@/components/modals/ChangePasswordModal";
import { useUser } from "@/context/UserContext";

const UserProfile = () => {
  const { user, loading } = useUser();
  const [isModalOpen, setIsModalOpen] = useState(false);

  if (loading) {
    return <div className="dark:text-white">Loading...</div>;
  }

  if (!user) {
    return <div className="p-4 text-red-500 bg-red-100 rounded-md dark:bg-red-900 dark:text-red-200">Failed to load user data.</div>;
  }

  return (
    <>
      <div className="grid grid-cols-1 gap-6 lg:grid-cols-4">
        {/* Left column for avatar and actions */}
        <div className="flex flex-col items-center col-span-1">
          <div className="relative w-32 h-32 mb-4">
            <Image
              src={user.avatar_url}
              alt="User"
              layout="fill"
              className="rounded-full"
            />
          </div>
          <h2 className="text-xl font-bold text-center text-black dark:text-white">
            {user.full_name}
          </h2>
          <p className="text-sm text-center text-gray-500 dark:text-gray-400">{user.username}</p>
          <div className="mt-6 text-center">
            <Button onClick={() => setIsModalOpen(true)}>تغییر رمز عبور</Button>
          </div>
        </div>

        {/* Right column for user details */}
        <div className="lg:col-span-3">
          <h3 className="mb-4 text-lg font-semibold text-black dark:text-white">
            جزئیات پروفایل
          </h3>
          <div className="grid grid-cols-1 gap-4 md:grid-cols-2">
            <div>
              <p className="mb-2 text-xs leading-normal text-gray-500 dark:text-gray-400">
                نام
              </p>
              <p className="text-sm font-medium text-gray-800 dark:text-white/90">
                {user.first_name || "-"}
              </p>
            </div>
            <div>
              <p className="mb-2 text-xs leading-normal text-gray-500 dark:text-gray-400">
                نام خانوادگی
              </p>
              <p className="text-sm font-medium text-gray-800 dark:text-white/90">
                {user.last_name || "-"}
              </p>
            </div>
            <div>
              <p className="mb-2 text-xs leading-normal text-gray-500 dark:text-gray-400">
                ایمیل
              </p>
              <p className="text-sm font-medium text-gray-800 dark:text-white/90">
                {user.email || "-"}
              </p>
            </div>
            <div>
              <p className="mb-2 text-xs leading-normal text-gray-500 dark:text-gray-400">
                شناسه کاربری
              </p>
              <p className="text-sm font-medium text-gray-800 dark:text-white/90">
                {user.id}
              </p>
            </div>
            <div>
              <p className="mb-2 text-xs leading-normal text-gray-500 dark:text-gray-400">
                تاریخ عضویت
              </p>
              <p className="text-sm font-medium text-gray-800 dark:text-white/90">
                {new Date(user.date_joined).toLocaleDateString("fa-IR")}
              </p>
            </div>
            <div>
              <p className="mb-2 text-xs leading-normal text-gray-500 dark:text-gray-400">
                وضعیت حساب
              </p>
              <p className="text-sm font-medium text-gray-800 dark:text-white/90">
                {user.is_active ? "Active" : "Inactive"}
              </p>
            </div>
          </div>
        </div>
      </div>

      <ChangePasswordModal
        isOpen={isModalOpen}
        onClose={() => setIsModalOpen(false)}
        userId={user.id}
        // isProfilePage={true}
      />
    </>
  );
};

export default UserProfile;
