'use client';

import React from 'react';
import Label from '@/components/form/Label';
import Input from '@/components/form/input/InputField';
import Select from '@/components/form/Select';
import { usePrescriptionContext } from '@/context/PrescriptionContext';

interface Filters {
  doctor_name: string;
  patient_name: string;
  patient_national_id__icontains: string;
  prescription_number__icontains: string;
  service_status: string;
  patient_base_insurance_issuer: string;
  patient_supplementary_insurance_issuer: string;
}

interface FilterPanelProps {
  filters: Filters;
  handleFilterChange: (e: React.ChangeEvent<HTMLInputElement | HTMLSelectElement>) => void;
  handleSelectFilterChange: (name: string, value: string) => void;
}

const FilterPanel = ({ filters, handleFilterChange, handleSelectFilterChange }: FilterPanelProps) => {
  const { doctors, baseInsurances, supplementaryInsurances } = usePrescriptionContext();

  return (
    <div className="grid grid-cols-1 gap-4 dark:text-gray-300">
      <div>
        <Label htmlFor="doctor">پزشک</Label>
        <Select
          options={[{ value: "", label: "همه" }, ...doctors.map(d => ({ value: d.full_name, label: d.full_name })) ]}
          placeholder="انتخاب پزشک"
          value={filters.doctor_name}
          onChange={(value) => handleSelectFilterChange("doctor_name", value)}
        />
      </div>
      <div>
        <Label htmlFor="prescription_number__icontains">کد پیگیری</Label>
        <Input
          type="text"
          name="prescription_number__icontains"
          id="prescription_number__icontains"
          placeholder="کد پیگیری"
          value={filters.prescription_number__icontains}
          onChange={handleFilterChange}
        />
      </div>
      <div>
        <Label htmlFor="patient_base_insurance_issuer">بیمه پایه</Label>
        <Select
          options={[{ value: "", label: "همه" }, ...baseInsurances.map(i => ({ value: i.id.toString(), label: i.name })) ]}
          placeholder="انتخاب بیمه پایه"
          value={filters.patient_base_insurance_issuer}
          onChange={(value) => handleSelectFilterChange("patient_base_insurance_issuer", value)}
        />
      </div>
      <div>
        <Label htmlFor="patient_supplementary_insurance_issuer">بیمه تکمیلی</Label>
        <Select
          options={[{ value: "", label: "همه" }, ...supplementaryInsurances.map(i => ({ value: i.id.toString(), label: i.name })) ]}
          placeholder="انتخاب بیمه تکمیلی"
          value={filters.patient_supplementary_insurance_issuer}
          onChange={(value) => handleSelectFilterChange("patient_supplementary_insurance_issuer", value)}
        />
      </div>
    </div>
  );
};

export default FilterPanel;
