// import { Outfit } from 'next/font/google';
import './globals.css';

import { SidebarProvider } from '@/context/SidebarContext';
import { ThemeProvider } from '@/context/ThemeContext';
import { UserProvider } from '@/context/UserContext';
import ToastProvider from '@/components/common/ToastProvider';
import localFont from "next/font/local";
import "./globals.css";

const vazirmatn = localFont({
  src: [
    { path: "../fonts/vazirmatn/Vazirmatn-Thin.woff2", weight: "100" },
    { path: "../fonts/vazirmatn/Vazirmatn-Thin.woff2", weight: "100" },
    { path: "../fonts/vazirmatn/Vazirmatn-Light.woff2", weight: "200" },
    { path: "../fonts/vazirmatn/Vazirmatn-Light.woff2", weight: "300" },
    { path: "../fonts/vazirmatn/Vazirmatn-Regular.woff2", weight: "400" },
    { path: "../fonts/vazirmatn/Vazirmatn-Medium.woff2", weight: "500" },
    { path: "../fonts/vazirmatn/Vazirmatn-SemiBold.woff2", weight: "600" },
    { path: "../fonts/vazirmatn/Vazirmatn-Bold.woff2", weight: "800" },
    { path: "../fonts/vazirmatn/Vazirmatn-Bold.woff2", weight: "900" },
  ],
  variable: "--font-vazirmatn",
  display: "swap",
});

// const outfit = Outfit({
//   subsets: ["latin"],
// });

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="fa">
      <body className={`${vazirmatn.className} dark:bg-gray-900`}>
      {/* <body className={`${outfit.className} dark:bg-gray-900`}> */}
        <ThemeProvider>
          <UserProvider>
            <SidebarProvider>
              {children}
              <ToastProvider />
            </SidebarProvider>
          </UserProvider>
        </ThemeProvider>
      </body>
    </html>
  );
}