import ComponentCard from "@/components/common/ComponentCard";
import PageBreadcrumb from "@/components/common/PageBreadCrumb";
import PrescriptionsTable from "@/components/tables/PrescriptionsTable";
import { PrescriptionProvider } from "@/context/PrescriptionContext";
import { Metadata } from "next";
import React from "react";

export const metadata: Metadata = {
  title: "Prescriptions",
  description: "This is the prescriptions page.",
};

export default function PrescriptionsPage() {
  return (
    <div className="w-full">
      <PageBreadcrumb pageTitle="نسخه ها" />
      <div className="space-y-6">
        <ComponentCard title="نسخه ها">
          <PrescriptionProvider>
            <PrescriptionsTable />
          </PrescriptionProvider>
        </ComponentCard>
      </div>
    </div>
  );
}