"use client";

import { useSidebar } from "@/context/SidebarContext";
import AppHeader from "@/layout/AppHeader";
import AppSidebar from "@/layout/AppSidebar";
import Backdrop from "@/layout/Backdrop";
import React from "react";

export default function AdminLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  const { isExpanded, isHovered, isMobileOpen } = useSidebar();

  // Dynamic class for main content margin based on sidebar state
  const mainContentMargin = isMobileOpen
    ? "ml-0"
    : isExpanded || isHovered
      ? "lg:ml-[290px]"
      : "lg:ml-[90px]";

  const mainContentWidth = isMobileOpen
    ? "w-full"
    : isExpanded || isHovered
      ? "lg:w-[calc(100%-290px)]"
      : "lg:w-[calc(100%-90px)]";
  return (
    <div className="min-h-screen md:flex text-xs">
      {/* Sidebar and Backdrop */}
      <AppSidebar />
      <Backdrop />
      {/* Main Content Area */}
      <div
        className={`flex-1 transition-all  duration-300 ease-in-out ${mainContentMargin} ${mainContentWidth} max-w-full`}
        // style={{ maxWidth: "calc(100vw - 290px)" }}
      >
        {/* Header */}
        <AppHeader />
        {/* Page Content */}
        {/* <div className="p-4 mx-auto max-w-(--breakpoint-2xl) md:p-6">{children}</div> */}
        {/* <div className="p-4 mx-auto max-w-full box-border md:p-6">{children}</div> */}
        <div className="p-4 mx-auto max-w-(--breakpoint-2xl) md:p-6">{children}</div>


      </div>
    </div>
  );
}
