import PageBreadcrumb from "@/components/common/PageBreadCrumb";
import ComponentCard from "@/components/common/ComponentCard";
import UserProfile from "@/components/user-profile/UserProfile";
import { Metadata } from "next";
import React from "react";

export const metadata: Metadata = {
  title: "Profile",
  description: "User profile page.",
};

export default function ProfilePage() {
  return (
    <div>
      <PageBreadcrumb pageTitle="پروفایل" />
      <div className="space-y-6">
        <ComponentCard title="پروفایل کاربر">
          <UserProfile />
        </ComponentCard>
      </div>
    </div>
  );
}

